package chim

import (
	"net/http"
	"net/url"
	"strings"
)

func StripPrefix(prefix string) func(http.Handler) http.Handler {
	return func(next http.Handler) http.Handler {
		fn := func(w http.ResponseWriter, r *http.Request) {
			var strippedReq *http.Request
			if p := strings.TrimPrefix(r.URL.Path, prefix); len(p) < len(r.URL.Path) {
				r2 := new(http.Request)
				*r2 = *r
				r2.URL = new(url.URL)
				*r2.URL = *r.URL
				r2.URL.Path = p
				strippedReq = r2
			} else {
				strippedReq = r
			}
			next.ServeHTTP(w, strippedReq)
		}
		return http.HandlerFunc(fn)
	}
}
