//go:build darwin || linux || freebsd
// +build darwin linux freebsd

package daemon

import (
	"fmt"
	"os"
	"syscall"
)

func (c *Cmd) BuildProcAttr() (*os.ProcAttr, error) {
	if c.built {
		return nil, ErrCmdAlreadyBuilt
	}

	childFiles, err := c.files()
	if err != nil {
		return nil, fmt.Errorf("can't build child files: %w", err)
	}

	c.childFiles = childFiles
	out := &os.ProcAttr{
		Dir:   c.Dir,
		Env:   c.Env,
		Files: childFiles,
		Sys: &syscall.SysProcAttr{
			Setsid: true,
		},
	}

	c.built = true
	return out, nil
}

func (c *Cmd) files() ([]*os.File, error) {
	childFiles := make([]*os.File, 4)
	type F func() (*os.File, error)
	for i, setupFd := range []F{c.stdinFile, c.stdoutFile, c.stderrFile, c.pipeFile} {
		fd, err := setupFd()
		if err != nil {
			c.closeDescriptors(c.closeAfterStart)
			c.closeDescriptors(c.closeAfterWait)
			return nil, err
		}

		childFiles[i] = fd
	}
	return childFiles, nil
}
