package daemon

import (
	"fmt"
	"os"
	"syscall"

	"golang.org/x/sys/windows"
)

func (c *Cmd) BuildProcAttr() (*os.ProcAttr, error) {
	if c.built {
		return nil, ErrCmdAlreadyBuilt
	}

	childFiles, err := c.files()
	if err != nil {
		return nil, fmt.Errorf("can't build child files: %w", err)
	}

	c.childFiles = childFiles
	out := &os.ProcAttr{
		Dir:   c.Dir,
		Env:   c.Env,
		Files: childFiles,
		Sys: &syscall.SysProcAttr{
			HideWindow:    true,
			CreationFlags: windows.CREATE_BREAKAWAY_FROM_JOB | windows.CREATE_NEW_PROCESS_GROUP | windows.DETACHED_PROCESS,
		},
	}

	c.built = true
	return out, nil
}

func (c *Cmd) files() ([]*os.File, error) {
	//TODO(buglloc): use SysProcAttr.AdditionalInheritedHandles instead of stdin after Go 1.17
	// https://github.com/golang/go/commit/3146166baa8c420dfe20619e4aa9978b87927268
	childFiles := make([]*os.File, 3)
	type F func() (*os.File, error)
	for i, setupFd := range []F{c.pipeFile, c.stdoutFile, c.stderrFile} {
		fd, err := setupFd()
		if err != nil {
			c.closeDescriptors(c.closeAfterStart)
			c.closeDescriptors(c.closeAfterWait)
			return nil, err
		}

		childFiles[i] = fd
	}
	return childFiles, nil
}
