package main

import (
	"context"
	"fmt"

	"a.yandex-team.ru/security/libs/go/daemon"
)

func main() {
	d := daemon.NewDaemon("simple")
	if d.IsParent() {
		child, err := d.StartChild(context.Background())
		if err != nil {
			panic(err)
		}

		fmt.Println("child started with PID", child.PID())
		return
	}

	if err := d.NotifyStarted(nil); err != nil {
		panic(err)
	}
}
