package main

import (
	"context"
	"fmt"
	"time"

	"a.yandex-team.ru/security/libs/go/daemon"
)

type Data struct {
	Foo string
	Bar int
}

func main() {
	d := daemon.NewDaemon("slow")
	if d.IsParent() {
		ctx, cancel := context.WithTimeout(context.Background(), time.Second)
		defer cancel()

		child, err := d.StartChild(ctx)
		if err != nil {
			panic(err)
		}

		fmt.Printf("child started with PID: %d\n", child.PID())
		var data Data
		err = child.Unmarshal(&data)
		if err != nil {
			panic(err)
		}

		fmt.Printf("data from child: %v\n", data)
		return
	}

	time.Sleep(2 * time.Second)
	if err := d.NotifyStarted(Data{Foo: "foo", Bar: 31337}); err != nil {
		panic(err)
	}
}
