package main

import (
	"context"
	"fmt"
	"os"

	"a.yandex-team.ru/security/libs/go/daemon"
)

type Data struct {
	Foo string
	Bar int
}

func main() {
	d := daemon.NewDaemon("slow", daemon.WithStderr(os.Stderr))
	if d.IsParent() {
		child, err := d.StartChild(context.Background())
		if err != nil {
			panic(err)
		}

		fmt.Printf("child started with PID: %d\n", child.PID())
		var data Data
		err = child.Unmarshal(&data)
		if err != nil {
			panic(err)
		}

		fmt.Printf("data from child: %v\n", data)
		return
	}

	fmt.Println("i'm stdout from child")
	_, _ = fmt.Fprintln(os.Stderr, "i'm stderr from child")
	if err := d.NotifyStarted(Data{Foo: "foo", Bar: 31337}); err != nil {
		panic(err)
	}
}
