package daemon

import "os"

type Option func(d *Daemon)

func WithEnv(env ...string) Option {
	return func(d *Daemon) {
		d.env = append(d.env, env...)
	}
}

func WithClearEnv() Option {
	return func(d *Daemon) {
		d.env = make([]string, 0)
	}
}

func WithArg(arg ...string) Option {
	return func(d *Daemon) {
		d.args = append(d.args, arg...)
	}
}

func WithClearArgs() Option {
	return func(d *Daemon) {
		d.args = make([]string, 0)
	}
}

func WithDir(dir string) Option {
	return func(d *Daemon) {
		d.dir = dir
	}
}

func WithStdout(f *os.File) Option {
	return func(d *Daemon) {
		d.stdout = f
	}
}

func WithStderr(f *os.File) Option {
	return func(d *Daemon) {
		d.stderr = f
	}
}
