package yrenderer

import (
	"strconv"

	"github.com/yuin/goldmark/ast"
	"github.com/yuin/goldmark/renderer"
	"github.com/yuin/goldmark/renderer/html"
	"github.com/yuin/goldmark/util"
)

var (
	_ renderer.NodeRenderer = (*FixedHeading)(nil)
)

type FixedHeading struct {
	html.Config
	level string
}

func NewFixedHeading(level int, opts ...html.Option) renderer.NodeRenderer {
	r := &FixedHeading{
		Config: html.NewConfig(),
		level:  strconv.Itoa(level),
	}

	for _, opt := range opts {
		opt.SetHTMLOption(&r.Config)
	}
	return r
}

// RegisterFuncs implements renderer.NodeRenderer.RegisterFuncs.
func (r *FixedHeading) RegisterFuncs(reg renderer.NodeRendererFuncRegisterer) {
	reg.Register(ast.KindHeading, r.renderHeading)
}

func (r *FixedHeading) renderHeading(w util.BufWriter, _ []byte, node ast.Node, entering bool) (ast.WalkStatus, error) {
	n := node.(*ast.Heading)

	if entering {
		_, _ = w.WriteString("<h")
		_, _ = w.WriteString(r.level)
		if n.Attributes() != nil {
			html.RenderAttributes(w, node, html.HeadingAttributeFilter)
		}
		_ = w.WriteByte('>')
	} else {
		_, _ = w.WriteString("</h")
		_, _ = w.WriteString(r.level)
		_, _ = w.WriteString(">\n")
	}

	return ast.WalkContinue, nil
}
