package hashreader

import (
	"crypto/md5"
	"crypto/sha1"
	"crypto/sha256"
	"hash"

	"golang.org/x/crypto/blake2b"
)

type Option interface {
	isOption()
}

type optionHash struct {
	Option
	name string
	hash hash.Hash
}

func WithHash(name string, h hash.Hash) Option {
	return optionHash{name: name, hash: h}
}

func WithMD5Hash() Option {
	return WithHash("md5", md5.New())
}

func WithSha1Hash() Option {
	return WithHash("sha1", sha1.New())
}

func WithSha256Hash() Option {
	return WithHash("sha256", sha256.New())
}

func WithBlakeHash() Option {
	h, err := blake2b.New256(nil)
	if err != nil {
		panic("blake2b: " + err.Error())
	}
	return WithHash("b2s", h)
}
