package iokit

import "fmt"

//go:generate go run ./iokit-errgen/main.go --in iokit_errors

type Error struct {
	// RetCode holds the return code for a given call.
	RetCode int64
	Msg     string
}

func (e *Error) Error() string {
	return fmt.Sprintf("err code 0x%08x: %s", e.RetCode, e.Msg)
}

type Device struct {
	name       string
	locationID uint32
}

func (d Device) String() string {
	return fmt.Sprintf("%s @0x%08x", d.name, d.locationID)
}

func (d *Device) Replug() error {
	return replug(d.locationID)
}
