//go:build cgo && darwin
// +build cgo,darwin

package iokit

// #include "iokit_darwin.h"
import "C"

func List(vendorID, productID int) ([]Device, error) {
	var buf [C.NDEVICE]C.struct_Device
	cgoRet := C.List(C.uint32_t(vendorID), C.uint32_t(productID), &buf[0])
	ret := fixRetCode(cgoRet)
	if ret != 0 {
		return nil, iokitErrorFromCode(ret)
	}

	out := make([]Device, 0)
	for _, cgoDevice := range buf {
		locationID := uint32(cgoDevice.locationID)
		if locationID == 0 {
			break
		}

		out = append(out, Device{
			name:       ioNameStr(cgoDevice.name),
			locationID: locationID,
		})
	}

	return out, nil
}

func replug(locationID uint32) error {
	cgoRet := C.Replug(C.uint32_t(locationID))
	ret := fixRetCode(cgoRet)
	if ret == 0 {
		return nil
	}
	return iokitErrorFromCode(ret)
}

func fixRetCode(r C.int) int64 {
	ret := int64(r)
	if ret < 0 {
		// On MacOS, int isn't big enough to handle the return codes so the
		// leading bit becomes a two's complement bit. If the return code is
		// negative, correct this.
		ret += 1 << 32
	}

	return ret
}

func ioNameStr(cs C.io_name_t) string {
	return C.GoStringN(&cs[0], C.int(C.strnlen(&cs[0], C.sizeof_io_name_t)))
}
