package lblight

import (
	"errors"
	"fmt"

	"a.yandex-team.ru/security/libs/go/lblight/internal/lbapi"
)

var (
	ErrClosed         = errors.New("writer was closed")
	ErrNextTry        = errors.New("next try")
	ErrNoStream       = errors.New("no gRPC stream available")
	ErrNoFeedback     = errors.New("received nil feedback message")
	ErrNilErrFeedback = errors.New("received nil error in feedback message")
)

type Error struct {
	Code        lbapi.EErrorCode
	Description string
}

func (e *Error) Error() string {
	return fmt.Sprintf("persqueue: %s (%d)", e.Description, e.Code)
}

func (e *Error) Retryable() bool {
	switch e.Code {
	case lbapi.EErrorCode_UNKNOWN_TOPIC, lbapi.EErrorCode_ACCESS_DENIED, lbapi.EErrorCode_BAD_REQUEST:
		return false
	default:
		return true
	}
}
