package lblight

import (
	"time"
)

type WriteMsg struct {
	Timestamp time.Time
	Data      []byte
	SeqNo     uint64
}

type FeedbackMsg interface {
	isFeedbackMsg()
}

type FeedbackMsgAck struct {
	FeedbackMsg
	SeqNo          uint64
	Offset         uint64
	AlreadyWritten bool
}

type FeedbackMsgAckBatch struct {
	FeedbackMsg
	ACKs []FeedbackMsgAck
}

type FeedbackMsgError struct {
	FeedbackMsg
	*Error
}

func (w *WriteMsg) PqTimestamp() uint64 {
	if w.Timestamp.IsZero() {
		return toTimestamp(time.Now())
	}

	return toTimestamp(w.Timestamp)
}

// ToTimestamp converts time to representation used by logbroker.
func toTimestamp(t time.Time) uint64 {
	return uint64(t.UnixNano() / int64(time.Millisecond))
}
