package lblight

import (
	"crypto/tls"
	"fmt"
	"net"
	"strconv"
	"strings"

	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials"

	"a.yandex-team.ru/library/go/core/log"
)

type SessionOption func(*session) error

func SessionWithLogger(l log.Logger) SessionOption {
	return func(s *session) error {
		s.log = l
		return nil
	}
}

func SessionWithEndpoint(endpoint string) SessionOption {
	return func(s *session) error {
		if strings.Contains(endpoint, ":") {
			host, rawPort, err := net.SplitHostPort(endpoint)
			if err != nil {
				return fmt.Errorf("invalid endpoint %q: %w", endpoint, err)
			}

			port, err := strconv.Atoi(rawPort)
			if err != nil {
				return fmt.Errorf("invalid port for endpoint %q: %w", endpoint, err)
			}

			s.settings.endpoint = host
			s.settings.port = port
			return nil
		}

		s.settings.endpoint = endpoint
		return nil
	}
}

func SessionWithProxy(proxy string) SessionOption {
	return func(s *session) error {
		s.settings.proxy = proxy
		return nil
	}
}

func SessionWithTLS(tlsConfig *tls.Config) SessionOption {
	return func(s *session) error {
		s.settings.grpcCreds = grpc.WithTransportCredentials(
			credentials.NewTLS(tlsConfig),
		)
		return nil
	}
}
