package lblight

import (
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb"
	"a.yandex-team.ru/library/go/core/log"
)

type WriterOption func(*Writer)

func WriterWithLogger(l log.Logger) WriterOption {
	return func(w *Writer) {
		w.log = l
	}
}

func WriterWithCreds(creds ydb.Credentials) WriterOption {
	return func(w *Writer) {
		w.credentials = creds
	}
}

func WriterWithEndpoint(endpoint string) WriterOption {
	return func(w *Writer) {
		w.endpoint = endpoint
	}
}

func WriterWithSourceID(sourceID string) WriterOption {
	return func(w *Writer) {
		w.sourceID = []byte(sourceID)
	}
}

func WriterWithRetries(retries int) WriterOption {
	return func(w *Writer) {
		w.retries = uint64(retries)
	}
}

func WriterWithCodec(codec Codec) WriterOption {
	return func(w *Writer) {
		w.codec = codec
	}
}

// TODO(buglloc): implement me
//func WriterWithAutoEncode(enabled bool) WriterOption {
//	return func(w *Writer) {
//		w.codec = codec
//	}
//}
