package machineid

import (
	"sync"
)

var (
	id     string
	idErr  error
	idOnce sync.Once
)

func ID() (string, error) {
	idOnce.Do(func() {
		id, idErr = machineID()
	})

	return id, idErr
}
