package pcsc

type Client interface {
	CheckCompatibility() error
	ListReaders() ([]string, error)
	Connect(reader string) (Handle, error)
	Close() error
}

type Handle interface {
	Begin() (Tx, error)
	Close() error
}

type Tx interface {
	Transmit(d APDU) ([]byte, error)
	Close() error
}

type APDU struct {
	Instruction byte
	Param1      byte
	Param2      byte
	Data        []byte
}
