// Code generated by pcsc-errgen. DO NOT EDIT.
package pcsc

import "fmt"

var (
	ErrSuccess                = &Error{RetCode: 0x00000000, Msg: "no error was encountered"}
	ErrInternalError          = &Error{RetCode: 0x80100001, Msg: "an internal consistency check failed"}
	ErrCancelled              = &Error{RetCode: 0x80100002, Msg: "the action was cancelled by an SCardCancel request"}
	ErrInvalidHandle          = &Error{RetCode: 0x80100003, Msg: "the supplied handle was invalid"}
	ErrInvalidParameter       = &Error{RetCode: 0x80100004, Msg: "one or more of the supplied parameters could not be properly interpreted"}
	ErrInvalidTarget          = &Error{RetCode: 0x80100005, Msg: "registry startup information is missing or invalid"}
	ErrNoMemory               = &Error{RetCode: 0x80100006, Msg: "not enough memory available to complete this command"}
	ErrWaitedTooLong          = &Error{RetCode: 0x80100007, Msg: "an internal consistency timer has expired"}
	ErrInsufficientBuffer     = &Error{RetCode: 0x80100008, Msg: "the data buffer to receive returned data is too small for the returned data"}
	ErrUnknownReader          = &Error{RetCode: 0x80100009, Msg: "the specified reader name is not recognized"}
	ErrTimeout                = &Error{RetCode: 0x8010000A, Msg: "the user-specified timeout value has expired"}
	ErrSharingViolation       = &Error{RetCode: 0x8010000B, Msg: "the smart card cannot be accessed because of other connections outstanding"}
	ErrNoSmartcard            = &Error{RetCode: 0x8010000C, Msg: "the operation requires a Smart Card, but no Smart Card is currently in the device"}
	ErrUnknownCard            = &Error{RetCode: 0x8010000D, Msg: "the specified smart card name is not recognized"}
	ErrCantDispose            = &Error{RetCode: 0x8010000E, Msg: "the system could not dispose of the media in the requested manner"}
	ErrProtoMismatch          = &Error{RetCode: 0x8010000F, Msg: "the requested protocols are incompatible with the protocol currently in use with the smart card"}
	ErrNotReady               = &Error{RetCode: 0x80100010, Msg: "the reader or smart card is not ready to accept commands"}
	ErrInvalidValue           = &Error{RetCode: 0x80100011, Msg: "one or more of the supplied parameters values could not be properly interpreted"}
	ErrSystemCancelled        = &Error{RetCode: 0x80100012, Msg: "the action was cancelled by the system, presumably to log off or shut down"}
	ErrCommError              = &Error{RetCode: 0x80100013, Msg: "an internal communications error has been detected"}
	ErrUnknownError           = &Error{RetCode: 0x80100014, Msg: "an internal error has been detected, but the source is unknown"}
	ErrInvalidAtr             = &Error{RetCode: 0x80100015, Msg: "an ATR obtained from the registry is not a valid ATR string"}
	ErrNotTransacted          = &Error{RetCode: 0x80100016, Msg: "an attempt was made to end a non-existent transaction"}
	ErrReaderUnavailable      = &Error{RetCode: 0x80100017, Msg: "the specified reader is not currently available for use"}
	ErrShutdown               = &Error{RetCode: 0x80100018, Msg: "the operation has been aborted to allow the server application to exit"}
	ErrPciTooSmall            = &Error{RetCode: 0x80100019, Msg: "the PCI Receive buffer was too small"}
	ErrReaderUnsupported      = &Error{RetCode: 0x8010001A, Msg: "the reader driver does not meet minimal requirements for support"}
	ErrDuplicateReader        = &Error{RetCode: 0x8010001B, Msg: "the reader driver did not produce a unique reader name"}
	ErrCardUnsupported        = &Error{RetCode: 0x8010001C, Msg: "the smart card does not meet minimal requirements for support"}
	ErrNoService              = &Error{RetCode: 0x8010001D, Msg: "the Smart card resource manager is not running"}
	ErrServiceStopped         = &Error{RetCode: 0x8010001E, Msg: "the Smart card resource manager has shut down"}
	ErrUnsupportedFeature     = &Error{RetCode: 0x8010001F, Msg: "this smart card does not support the requested feature"}
	ErrIccInstallation        = &Error{RetCode: 0x80100020, Msg: "no primary provider can be found for the smart card"}
	ErrIccCreateorder         = &Error{RetCode: 0x80100021, Msg: "the requested order of object creation is not supported"}
	ErrDirNotFound            = &Error{RetCode: 0x80100023, Msg: "the identified directory does not exist in the smart card"}
	ErrFileNotFound           = &Error{RetCode: 0x80100024, Msg: "the identified file does not exist in the smart card"}
	ErrNoDir                  = &Error{RetCode: 0x80100025, Msg: "the supplied path does not represent a smart card directory"}
	ErrNoFile                 = &Error{RetCode: 0x80100026, Msg: "the supplied path does not represent a smart card file"}
	ErrNoAccess               = &Error{RetCode: 0x80100027, Msg: "access is denied to this file"}
	ErrWriteTooMany           = &Error{RetCode: 0x80100028, Msg: "the smart card does not have enough memory to store the information"}
	ErrBadSeek                = &Error{RetCode: 0x80100029, Msg: "there was an error trying to set the smart card file object pointer"}
	ErrInvalidChv             = &Error{RetCode: 0x8010002A, Msg: "the supplied PIN is incorrect"}
	ErrUnknownResMng          = &Error{RetCode: 0x8010002B, Msg: "an unrecognized error code was returned from a layered component"}
	ErrNoSuchCertificate      = &Error{RetCode: 0x8010002C, Msg: "the requested certificate does not exist"}
	ErrCertificateUnavailable = &Error{RetCode: 0x8010002D, Msg: "the requested certificate could not be obtained"}
	ErrNoReadersAvailable     = &Error{RetCode: 0x8010002E, Msg: "cannot find a smart card reader"}
	ErrCommDataLost           = &Error{RetCode: 0x8010002F, Msg: "a communications error with the smart card has been detected. Retry the operation"}
	ErrNoKeyContainer         = &Error{RetCode: 0x80100030, Msg: "the requested key container does not exist on the smart card"}
	ErrServerTooBusy          = &Error{RetCode: 0x80100031, Msg: "the Smart Card Resource Manager is too busy to complete this operation"}
	ErrUnsupportedCard        = &Error{RetCode: 0x80100065, Msg: "the reader cannot communicate with the card, due to ATR string configuration conflicts"}
	ErrUnresponsiveCard       = &Error{RetCode: 0x80100066, Msg: "the smart card is not responding to a reset"}
	ErrUnpoweredCard          = &Error{RetCode: 0x80100067, Msg: "power has been removed from the smart card, so that further communication is not possible"}
	ErrResetCard              = &Error{RetCode: 0x80100068, Msg: "the smart card has been reset, so any shared state information is invalid"}
	ErrRemovedCard            = &Error{RetCode: 0x80100069, Msg: "the smart card has been removed, so further communication is not possible"}
	ErrSecurityViolation      = &Error{RetCode: 0x8010006A, Msg: "access was denied because of a security violation"}
	ErrWrongChv               = &Error{RetCode: 0x8010006B, Msg: "the card cannot be accessed because the wrong PIN was presented"}
	ErrChvBlocked             = &Error{RetCode: 0x8010006C, Msg: "the card cannot be accessed because the maximum number of PIN entry attempts has been reached"}
	ErrEof                    = &Error{RetCode: 0x8010006D, Msg: "the end of the smart card file has been reached"}
	ErrCancelledByUser        = &Error{RetCode: 0x8010006E, Msg: "the user pressed \"Cancel\" on a Smart Card Selection Dialog"}
	ErrCardNotAuthenticated   = &Error{RetCode: 0x8010006F, Msg: "no PIN was presented to the smart card"}
)

func pcscErrorFromCode(rc int64) *Error {
	switch rc {
	case 0x00000000:
		return ErrSuccess
	case 0x80100001:
		return ErrInternalError
	case 0x80100002:
		return ErrCancelled
	case 0x80100003:
		return ErrInvalidHandle
	case 0x80100004:
		return ErrInvalidParameter
	case 0x80100005:
		return ErrInvalidTarget
	case 0x80100006:
		return ErrNoMemory
	case 0x80100007:
		return ErrWaitedTooLong
	case 0x80100008:
		return ErrInsufficientBuffer
	case 0x80100009:
		return ErrUnknownReader
	case 0x8010000A:
		return ErrTimeout
	case 0x8010000B:
		return ErrSharingViolation
	case 0x8010000C:
		return ErrNoSmartcard
	case 0x8010000D:
		return ErrUnknownCard
	case 0x8010000E:
		return ErrCantDispose
	case 0x8010000F:
		return ErrProtoMismatch
	case 0x80100010:
		return ErrNotReady
	case 0x80100011:
		return ErrInvalidValue
	case 0x80100012:
		return ErrSystemCancelled
	case 0x80100013:
		return ErrCommError
	case 0x80100014:
		return ErrUnknownError
	case 0x80100015:
		return ErrInvalidAtr
	case 0x80100016:
		return ErrNotTransacted
	case 0x80100017:
		return ErrReaderUnavailable
	case 0x80100018:
		return ErrShutdown
	case 0x80100019:
		return ErrPciTooSmall
	case 0x8010001A:
		return ErrReaderUnsupported
	case 0x8010001B:
		return ErrDuplicateReader
	case 0x8010001C:
		return ErrCardUnsupported
	case 0x8010001D:
		return ErrNoService
	case 0x8010001E:
		return ErrServiceStopped
	case 0x8010001F:
		return ErrUnsupportedFeature
	case 0x80100020:
		return ErrIccInstallation
	case 0x80100021:
		return ErrIccCreateorder
	case 0x80100023:
		return ErrDirNotFound
	case 0x80100024:
		return ErrFileNotFound
	case 0x80100025:
		return ErrNoDir
	case 0x80100026:
		return ErrNoFile
	case 0x80100027:
		return ErrNoAccess
	case 0x80100028:
		return ErrWriteTooMany
	case 0x80100029:
		return ErrBadSeek
	case 0x8010002A:
		return ErrInvalidChv
	case 0x8010002B:
		return ErrUnknownResMng
	case 0x8010002C:
		return ErrNoSuchCertificate
	case 0x8010002D:
		return ErrCertificateUnavailable
	case 0x8010002E:
		return ErrNoReadersAvailable
	case 0x8010002F:
		return ErrCommDataLost
	case 0x80100030:
		return ErrNoKeyContainer
	case 0x80100031:
		return ErrServerTooBusy
	case 0x80100065:
		return ErrUnsupportedCard
	case 0x80100066:
		return ErrUnresponsiveCard
	case 0x80100067:
		return ErrUnpoweredCard
	case 0x80100068:
		return ErrResetCard
	case 0x80100069:
		return ErrRemovedCard
	case 0x8010006A:
		return ErrSecurityViolation
	case 0x8010006B:
		return ErrWrongChv
	case 0x8010006C:
		return ErrChvBlocked
	case 0x8010006D:
		return ErrEof
	case 0x8010006E:
		return ErrCancelledByUser
	case 0x8010006F:
		return ErrCardNotAuthenticated
	default:
		return &Error{RetCode: rc, Msg: fmt.Sprintf("unknown pcsc return code 0x%08x", rc)}
	}
}
