package piv

import (
	"errors"
	"fmt"

	"a.yandex-team.ru/security/libs/go/pcsc"
)

var ErrNotFound = pcsc.ErrNotFound

var ErrNoManagementKey = errors.New("no stored management key available")

type AuthErr = pcsc.AuthErr

func IsAuthErr(err error) bool {
	var e *AuthErr
	return errors.As(err, &e)
}

// VersionErr is an error indicating that the minimum version of yubikey does not meet the requirements
type VersionErr struct {
	CurVersion string
	MinVersion string
}

func (v VersionErr) Error() string {
	return fmt.Sprintf("required %s version, but used yubikey of version %s", v.MinVersion, v.CurVersion)
}
func IsVersionErr(err error) bool {
	var e *VersionErr
	return errors.As(err, &e)
}
