package piv

import (
	"errors"

	"a.yandex-team.ru/security/libs/go/pcsc"
)

func IsPCSCAvailable() bool {
	pc, err := pcsc.NewClient()
	if err != nil {
		return !IsPCSCNotRunning(err)
	}
	_ = pc.Close()

	return true
}

func IsPCSCNotRunning(err error) bool {
	return errors.Is(err, pcsc.ErrNoService) || errors.Is(err, pcsc.ErrServiceStopped)
}
