package porto

import "fmt"

type VirtMode int

const (
	VirtModeUnknown VirtMode = iota
	// start command as normal process (default)
	VirtModeApp
	// start command as init process
	VirtModeOs
	// start command without security restrictions
	VirtModeHost
	// start command as process group in parent container
	VirtModeJob
)

func (s VirtMode) String() string {
	switch s {
	case VirtModeApp:
		return "app"
	case VirtModeOs:
		return "os"
	case VirtModeHost:
		return "host"
	case VirtModeJob:
		return "job"
	default:
		return "unknown"
	}
}

func VirtModeParse(value string) (VirtMode, error) {
	switch value {
	case "app":
		return VirtModeApp, nil
	case "os":
		return VirtModeOs, nil
	case "host":
		return VirtModeHost, nil
	case "job":
		return VirtModeJob, nil
	default:
		return VirtModeUnknown, fmt.Errorf("unknown virt_mode: %s", value)
	}
}
