package main

import (
	"fmt"
	"log"

	"github.com/gofrs/uuid"

	"a.yandex-team.ru/security/libs/go/porto"
)

func checkErr(err error) {
	if err != nil {
		panic(err)
	}
}

func main() {
	api, err := porto.NewAPI(nil)
	if err != nil {
		panic(err)
	}
	defer func() {
		err := api.Close()
		if err != nil {
			log.Println(err)
		}
	}()

	portoVersion, err := api.Version()
	checkErr(err)
	fmt.Printf("porto version: %s\n", portoVersion)

	rnd, _ := uuid.NewGen().NewV4()
	containerName := fmt.Sprintf("container-%s", rnd)
	container, err := api.CreateWeakContainer(containerName)
	checkErr(err)
	fmt.Printf("created container: %s", container.GetName())

	err = container.SetProperty("command", "ls -la /")
	checkErr(err)
	err = container.SetProperty("stdout_path", "/dev/fd/1")
	checkErr(err)
	err = container.SetProperty("stderr_path", "/dev/fd/2")
	checkErr(err)

	fmt.Println("container configured")

	err = container.Start()
	checkErr(err)
	fmt.Println("container started")

	done, err := container.Wait(-1)
	checkErr(err)

	if done {
		fmt.Println("container waited")
	} else {
		fmt.Println("timed out")
	}
}
