package main

import (
	"fmt"
	"log"

	"a.yandex-team.ru/security/libs/go/porto"
)

func main() {
	api, err := porto.NewAPI(nil)
	if err != nil {
		panic(err)
	}

	portoVersion, err := api.Version()
	if err != nil {
		panic(err)
	}
	fmt.Printf("porto version: %s\n", portoVersion)

	list, err := api.ListContainers()
	if err != nil {
		panic(err)
	}

	for _, c := range list {
		fmt.Printf("container: %s\n", c.GetName())
		state, err := c.GetState()
		if err != nil {
			log.Println(err)
		} else {
			fmt.Printf("\tstate: %s\n", state)
		}

		portoAccess, err := c.GetPortoAccess()
		if err != nil {
			log.Println(err)
		} else {
			fmt.Printf("\tenable_porto: %s\n", portoAccess)
		}

		virtMode, err := c.GetVirtMode()
		if err != nil {
			log.Println(err)
		} else {
			fmt.Printf("\tvirt_mode: %s\n", virtMode)
		}

		caps, err := c.GetCapabilities()
		if err != nil {
			log.Println(err)
		} else {
			fmt.Printf("\tcapabilities: %s\n", caps)
		}

		env, err := c.GetEnv()
		if err != nil {
			log.Println(err)
		} else {
			fmt.Println("\tenvs:")
			for k, v := range env {
				fmt.Printf("\t\t%s=%s\n", k, v)
			}
		}
	}
}
