package strutils

import (
	"strings"
)

func SplitQuoted(s string, quote byte) (result []string) {
	// Is it trivial?
	if len(s) == 0 {
		return
	}

	if strings.IndexByte(s, quote) == -1 {
		result = []string{s}
		return
	}

	var current strings.Builder
	last := len(s) - 1
	for i := 0; i <= last; i++ {
		r := s[i]
		switch r {
		case '\\':
			if i != last && s[i+1] == quote {
				current.WriteByte(quote)
				i++
			} else {
				current.WriteByte(r)
			}
		case quote:
			str := strings.TrimSpace(current.String())
			if len(str) > 0 {
				result = append(result, str)
			}
			current.Reset()
		default:
			current.WriteByte(r)
		}
	}

	if current.Len() > 0 {
		str := strings.TrimSpace(current.String())
		if len(str) > 0 {
			result = append(result, strings.TrimSpace(current.String()))
		}
	}
	return
}
