package porto

import (
	"fmt"
)

type (
	Volume struct {
		path      string
		container string
		porto     *Connection
	}
)

// Get volume path
func (v *Volume) Path() string {
	return v.path
}

// Return volume properties
func (v *Volume) GetProperties() (map[string]string, error) {
	desc, err := v.porto.GetVolume(v.path, v.container)
	if err != nil {
		return nil, err
	}

	return desc.Properties, nil
}

// Return volume property
func (v *Volume) GetProperty(name string) (result string, resultErr error) {
	properties, err := v.GetProperties()
	if err != nil {
		resultErr = err
		return
	}

	var ok bool
	result, ok = properties[name]
	if !ok {
		resultErr = fmt.Errorf("unknown property: %s", name)
		return
	}

	return
}

// Returns linked containers
func (v *Volume) GetContainers() (result []string, resultErr error) {
	desc, err := v.porto.GetVolume(v.path, v.container)
	if err != nil {
		resultErr = err
		return
	}

	result = desc.Containers
	return
}

func (v *Volume) Destroy() error {
	return v.porto.UnlinkVolume(v.path, "***")
}
