package main

import (
	"errors"
	"fmt"
	"strconv"
	"strings"

	"a.yandex-team.ru/security/libs/go/prompt"
)

func main() {
	ui, err := prompt.NewUI(prompt.UIOptions{})
	if err != nil {
		panic(err)
	}

	defaultName := ""
	defaultAge := "18"
	for {
		name, err := ui.Ask(prompt.AskOptions{
			Query:   "What is your name?",
			Default: defaultName,
		})

		if err != nil {
			panic(err)
		}

		age, err := ui.Ask(prompt.AskOptions{
			Query:   "How old are you?",
			Default: defaultAge,
			ValidateFunc: func(prompt string) error {
				age, err := strconv.Atoi(prompt)
				if err != nil {
					return err
				}

				if age < 18 {
					return errors.New("go away baby")
				}

				if age > 60 {
					return errors.New("go away daddy")
				}
				return nil
			},
		})

		if err != nil {
			panic(err)
		}

		fmt.Println("Your answers:")
		fmt.Printf("\t - name: %s\n", name)
		fmt.Printf("\t - age: %s\n", age)
		fmt.Println()

		ok := false
		_, err = ui.Ask(prompt.AskOptions{
			Query:   "Is this ok?",
			Default: "yes",
			ValidateFunc: func(prompt string) error {
				switch strings.ToLower(prompt) {
				case "y", "yes":
					ok = true
				case "n", "no":
					break
				default:
					return errors.New("must be Yes or No")
				}

				return nil
			},
		})

		if err != nil {
			panic(err)
		}

		if !ok {
			defaultName = name
			defaultAge = age
			continue
		}

		break
	}
}
