package prompt

import (
	"fmt"
	"io"
	"os"
	"os/signal"
	"strings"
)

func (i *UI) read() (result string, resultErr error) {
	sigCh := make(chan os.Signal, 1)
	signal.Notify(sigCh, os.Interrupt)
	defer signal.Stop(sigCh)

	doneCh := make(chan interface{})
	go func() {
		defer close(doneCh)

		line, err := i.bReader.ReadString('\n')
		if err != nil && err != io.EOF {
			resultErr = fmt.Errorf("failed to read the prompt: %s", err)
		}

		result = strings.TrimSpace(line)
	}()

	select {
	case <-sigCh:
		return "", ErrInterrupted
	case <-doneCh:
		return
	}
}
