package prompt

import (
	"bufio"
	"io"
	"os"
)

type (
	UIOptions struct {
		// Writer is where output is written (default=os.Stdout)
		Writer io.Writer

		// Reader is source of prompt (default=os.Stdin)
		Reader io.Reader
	}

	// ValidateFunc is function to validate the user prompt.
	ValidateFunc func(string) error

	UI struct {
		writer  io.Writer
		reader  io.Reader
		bReader *bufio.Reader
	}
)

func NewUI(opts UIOptions) (*UI, error) {
	result := &UI{}
	if opts.Reader != nil {
		result.reader = opts.Reader
	} else {
		result.reader = os.Stdin
	}

	if opts.Writer != nil {
		result.writer = opts.Writer
	} else {
		result.writer = os.Stdout
	}

	result.bReader = bufio.NewReader(result.reader)
	return result, nil
}
