package pypi

const (
	PackageTypeSrc PackageType = iota
	PackageTypeSrcEgg
	PackageTypeWheel
)

type Client interface {
	Name() string
	Error() error
	Next() bool
	Package() (Package, error)
	FindPackage(name string) (Package, error)
}

type Package interface {
	// Name returns pkg name
	Name() string

	// NormName returns normalized name, mostly according to PIP-503
	NormName() string

	// Resolve request additional info from pypi and completely resolve pkg information
	Resolve() error

	// Releases returns known releases to each released version
	Releases() Releases
}

type Release struct {
	Version     string
	Ext         string
	DownloadURL string
	Size        int
	Type        PackageType
}

type Releases map[string][]Release

type PackageType int8
