package main

import (
	"fmt"
	"os"

	"a.yandex-team.ru/security/libs/go/pypi/repos/pypilocalshop"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

func checkErr(err error) {
	if err != nil {
		panic(err)
	}
}

func main() {
	simplelog.SetLevel(simplelog.DebugLevel)
	localshop, err := pypilocalshop.New(pypilocalshop.Options{
		Name:      "test",
		BaseURL:   "https://pypi.yandex-team.ru",
		LocalOnly: true,
		Login:     os.Getenv("LOCALSHOP_USER"),
		Password:  os.Getenv("LOCALSHOP_PASSWORD"),
	})
	checkErr(err)

	for localshop.Next() {
		pkg, err := localshop.Package()
		if err != nil {
			simplelog.Error("failed to get package", "err", err)
			continue
		}

		if err = pkg.Resolve(); err != nil {
			simplelog.Error("failed to resolve package", "err", err)
			continue
		}

		fmt.Printf("pkg: %s\n", pkg.Name())
		for _, releaseDetails := range pkg.Releases() {
			for _, release := range releaseDetails {
				fmt.Println(release)
			}
		}
	}

	err = localshop.Error()
	checkErr(err)
}
