package main

import (
	"fmt"

	"a.yandex-team.ru/security/libs/go/pypi"
	"a.yandex-team.ru/security/libs/go/pypi/repos/pypisimple"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

func checkErr(err error) {
	if err != nil {
		panic(err)
	}
}

func processPkg(pkg pypi.Package, err error) {
	if err != nil {
		simplelog.Error("failed to get package", "err", err)
		return
	}

	if err = pkg.Resolve(); err != nil {
		simplelog.Error("failed to resolve package", "err", err)
		return
	}

	fmt.Printf("pkg: %s\n", pkg.Name())
	for _, releaseDetails := range pkg.Releases() {
		for _, release := range releaseDetails {
			fmt.Println(release)
		}
	}
}

func main() {
	simplelog.SetLevel(simplelog.DebugLevel)
	pypi, err := pypisimple.New(pypisimple.Options{
		Name:    "test",
		BaseURL: "http://pypi.yandex-team.ru",
	})
	checkErr(err)

	fmt.Println("resolve single pkg")
	processPkg(pypi.FindPackage("Django"))

	fmt.Println("walk through all pkgs")
	for pypi.Next() {
		processPkg(pypi.Package())
	}

	err = pypi.Error()
	checkErr(err)
}
