package backoff

import "time"

type (
	FixedStrategy struct {
		delay time.Duration
	}
)

// NewFixed returns strategy perform backoff with fixed delay for all iterations.
func NewFixed(delay time.Duration) *FixedStrategy {
	return &FixedStrategy{
		delay: delay,
	}
}

func (s *FixedStrategy) Delay(err error, attempt int) time.Duration {
	return s.delay
}
