package retry

import (
	"a.yandex-team.ru/security/libs/go/retry/backoff"
)

const (
	InfinityAttempts = 0
)

type (
	Options struct {
		Attempts  int
		BackOff   backoff.Strategy
		Condition ConditionFunc
	}

	Option func(*Options)
)

// WithAttempts sets retry attempts
//
// Set attempts to InfinityAttempts to retry forever (i.e. until ctx was canceled or condition breaks if any).
func WithAttempts(attempts int) Option {
	return func(opts *Options) {
		opts.Attempts = attempts
	}
}

// WithBackOff sets backoff strategy.
func WithBackOff(strategy backoff.Strategy) Option {
	return func(opts *Options) {
		opts.BackOff = strategy
	}
}

// WithCondition sets a retry condition function, that are checked to determine if we can continue retrying or not.
// Return false to stop retrying
func WithCondition(fn ConditionFunc) Option {
	return func(opts *Options) {
		opts.Condition = fn
	}
}
