package sectools

import (
	"context"
	"net"
	"net/http"
	"time"
)

func newHTTPTransport() *http.Transport {
	dialer := net.Dialer{
		Timeout:   2 * time.Second,
		KeepAlive: 60 * time.Second,
	}

	transport := http.DefaultTransport.(*http.Transport).Clone()
	transport.DialContext = func(ctx context.Context, network, addr string) (net.Conn, error) {
		return dialer.DialContext(ctx, "tcp6", addr)
	}

	return transport
}
