//go:build !freebsd
// +build !freebsd

package sectools

import (
	"net"
	"net/http"
	"time"
)

func newHTTPTransport() *http.Transport {
	transport := http.DefaultTransport.(*http.Transport).Clone()
	transport.DialContext = (&net.Dialer{
		Timeout:   2 * time.Second,
		KeepAlive: 60 * time.Second,
	}).DialContext

	return transport
}
