package sectools

import (
	"fmt"

	"a.yandex-team.ru/library/go/httputil/headers"
)

type Option func(*Client)

func WithRetries(count int) Option {
	return func(c *Client) {
		c.httpc.SetRetryCount(count)
	}
}

func WithUpstream(upstream string) Option {
	return func(c *Client) {
		c.httpc.SetBaseURL(upstream)
	}
}

func WithChannel(channel Channel) Option {
	return func(c *Client) {
		c.channel = channel
	}
}

func WithPreferFastURL() Option {
	return func(c *Client) {
		c.httpc.SetBaseURL(fastUpstream)
		c.preferFaster = true
	}
}

func WithCurrentVersion(version string) Option {
	return func(c *Client) {
		c.currentVersion = version
		c.httpc.SetHeader(headers.UserAgentKey, fmt.Sprintf(uaFormat, c.toolName, version))
	}
}

func WithArch(arch string) Option {
	return func(c *Client) {
		c.arch = arch
	}
}

func WithOS(os string) Option {
	return func(c *Client) {
		c.os = os
	}
}
