package main

import (
	"errors"
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/libs/go/sfx"
)

var rootCmd = &cobra.Command{
	Use:          "sfx",
	SilenceUsage: true,
}

var createCmd = &cobra.Command{
	Use:          "create [flags] /path/to/dst /path/to/src_0 /path/to/src_N",
	SilenceUsage: true,
	RunE: func(_ *cobra.Command, args []string) error {
		if len(args) < 2 {
			return errors.New("no src or dst provider")
		}

		return sfx.Zip(args[0], args[1:])
	},
}

var listCmd = &cobra.Command{
	Use:          "list [flags] /path/to/arc /path/to/arc_1",
	SilenceUsage: true,
	RunE: func(_ *cobra.Command, args []string) error {
		list := func(target string) error {
			list, err := sfx.List(target)
			if err != nil {
				return err
			}

			for _, f := range list {
				fmt.Printf("  %s\n", f)
			}
			return nil
		}

		if len(args) == 1 {
			return list(args[0])
		}

		for _, path := range args {
			fmt.Println(path)
			if err := list(path); err != nil {
				return err
			}
		}

		return nil
	},
}

var extractCmd = &cobra.Command{
	Use:          "extract [flags] /path/to/arc /path/to/arc_1",
	SilenceUsage: true,
	RunE: func(_ *cobra.Command, args []string) error {
		dst := "."
		if len(args) > 1 {
			dst = args[1]
		}

		return sfx.Unzip(args[0], dst)
	},
}

func main() {
	rootCmd.AddCommand(
		createCmd,
		listCmd,
		extractCmd,
	)

	if err := rootCmd.Execute(); err != nil {
		_, _ = fmt.Fprintf(os.Stderr, "sfx: %v\n", err)
		os.Exit(1)
	}
}
