package signer

import "a.yandex-team.ru/library/go/core/log"

type Option interface {
	isOption()
}

type SignOption interface {
	isSignOption()
}

type optionLog struct {
	Option
	l log.Logger
}

func WithLogger(l log.Logger) Option {
	return optionLog{l: l}
}

type optionEndpoint struct {
	Option
	endpoint string
}

func WithEndpoint(endpoint string) Option {
	return optionEndpoint{endpoint: endpoint}
}

type optionAuthToken struct {
	Option
	token string
}

func WithAuthToken(token string) Option {
	return optionAuthToken{token: token}
}

type optionRetries struct {
	Option
	retries int
}

func WithRetries(retries int) Option {
	return optionRetries{retries: retries}
}

type optionApp struct {
	Option
	app string
}

func WithApplication(app string) Option {
	return optionApp{app: app}
}

type signOptionApp struct {
	SignOption
	app string
}

func WithSignApplication(app string) SignOption {
	return signOptionApp{app: app}
}

type signOptionComment struct {
	SignOption
	comment string
}

func WithSignComment(comment string) SignOption {
	return signOptionComment{comment: comment}
}
