package main

import (
	"errors"
	"flag"
	"os"

	"a.yandex-team.ru/security/libs/go/simplelog"
)

func main() {
	var outFile string
	flag.StringVar(&outFile, "file", "test", "output log file")
	flag.Parse()

	f, err := os.Create(outFile)
	if err != nil {
		panic(err)
	}
	defer func() { _ = f.Close() }()

	logger := simplelog.NewLogger(
		&simplelog.LoggerOpts{
			Writer: f,
		},
	)

	logger.Warn("first line", "str_param", "str", "int_format", 1)
	logger.Warn("second line", "err", errors.New("test err"))
}
