package simplelog

import (
	"os"

	"golang.org/x/crypto/ssh/terminal"
)

var (
	logger = NewLogger(&LoggerOpts{
		Writer:  os.Stderr,
		Colored: terminal.IsTerminal(int(os.Stderr.Fd())),
	})
)

func SetLevel(level Lvl) {
	maxLvl = level
}

func Debug(msg string, ctx ...interface{}) {
	logger.Debug(msg, ctx...)
}

func Info(msg string, ctx ...interface{}) {
	logger.Info(msg, ctx...)
}

func Warn(msg string, ctx ...interface{}) {
	logger.Warn(msg, ctx...)
}

func Error(msg string, ctx ...interface{}) {
	logger.Error(msg, ctx...)
}

func Crit(msg string, ctx ...interface{}) {
	logger.Crit(msg, ctx...)
}

func Child(ctx ...interface{}) *Logger {
	return logger.Child(ctx...)
}
