package xlock

import "context"

var _ Locker = (*NopLocker)(nil)

type NopLocker struct {
}

type NopLock struct {
	ctx context.Context
}

func (n *NopLocker) Lock(ctx context.Context) (Lock, error) {
	return &NopLock{
		ctx: ctx,
	}, nil
}

func (l *NopLock) Unlock() error {
	return nil
}

func (l *NopLock) Context() context.Context {
	return l.ctx
}
