package xlock

import (
	"context"
	"fmt"

	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/yt/go/yt"
	"a.yandex-team.ru/yt/go/yt/ythttp"
	"a.yandex-team.ru/yt/go/ytlock"
)

var _ Locker = (*YTLocker)(nil)

type YTLocker struct {
	ytClient yt.Client
	path     ypath.Path
}

type YTLock struct {
	ctx context.Context
	l   *ytlock.Lock
}

func NewYTLockerWithClient(ytClient yt.Client, path ypath.Path) *YTLocker {
	return &YTLocker{
		ytClient: ytClient,
		path:     path,
	}
}

func NewYTLocker(proxy, path, token string) (*YTLocker, error) {
	ytClient, err := ythttp.NewClient(&yt.Config{
		Proxy: proxy,
		Token: token,
	})
	if err != nil {
		return nil, fmt.Errorf("create YT client: %w", err)
	}

	return NewYTLockerWithClient(ytClient, ypath.Path(path)), nil
}

func (l *YTLocker) Lock(ctx context.Context) (Lock, error) {
	lock := ytlock.NewLockOptions(l.ytClient, l.path, ytlock.Options{
		CreateIfMissing: true,
		LockMode:        yt.LockExclusive,
	})

	ctx, cancelCtx := context.WithCancel(ctx)
	tx, err := lock.Acquire(ctx)
	if err != nil {
		cancelCtx()
		return nil, err
	}

	go func() {
		<-tx
		cancelCtx()
	}()

	return &YTLock{
		ctx: ctx,
		l:   lock,
	}, nil
}

func (l *YTLock) Unlock() error {
	return l.l.Release(context.Background())
}

func (l *YTLock) Context() context.Context {
	return l.ctx
}
