package xlog

import (
	"fmt"
	"net/url"
)

// workaround for https://github.com/uber-go/zap/issues/621

func LogURL(logPath string) string {
	switch logPath {
	case "stdout", "stderr":
		return logPath
	}

	return SchemeLogURL(DefaultXRotateScheme, logPath)
}

func SchemeLogURL(scheme, logPath string) string {
	return fmt.Sprintf("%s:///%s", DefaultXRotateScheme, url.PathEscape(logPath))
}
