package xtvm

import (
	"context"
	"fmt"
	"time"

	"github.com/cenkalti/backoff/v4"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

const backoffDuration = time.Second

func Wait(tvmc tvm.Client, timeout time.Duration) error {
	ctx, cancel := context.WithTimeout(context.Background(), timeout)
	defer cancel()

	return backoff.Retry(
		func() error {
			rsp, err := tvmc.GetStatus(ctx)
			if err != nil {
				return err
			}

			if rsp.Status != tvm.ClientOK {
				return fmt.Errorf("non-ok tvm status: %s", rsp.Status)
			}

			return nil
		},
		backoff.WithContext(backoff.NewConstantBackOff(backoffDuration), ctx),
	)
}
