package ydbtvm

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/library/go/yandex/ydb/auth/tvm2"
)

const (
	YDBClientID = tvm2.YdbClientID
	LbClientID  = tvm2.LogbrokerTvmClientID
)

type (
	TvmCredentials struct {
		DstID     tvm.ClientID
		TvmClient tvm.Client
	}
)

func (c *TvmCredentials) Token(ctx context.Context) (string, error) {
	return c.TvmClient.GetServiceTicketForID(ctx, c.DstID)
}
