package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/mac-signer/internal/storage"
)

var logger log.Logger
var s3Config = storage.Config{
	Endpoint:        "s3.mds.yandex.net",
	Bucket:          "mac-signs",
	AccessKeyID:     os.Getenv("S3_ACCESS_KEY_ID"),
	SecretAccessKey: os.Getenv("S3_SECRET_ACCESS_KEY"),
}

var rootCmd = &cobra.Command{
	Use:          "homosign",
	SilenceUsage: true,
	PersistentPreRunE: func(cmd *cobra.Command, _ []string) error {
		var err error
		logger, err = zap.New(zap.KVConfig(log.DebugLevel))
		if err != nil {
			return fmt.Errorf("can't create logger: %w", err)
		}

		return nil
	},
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	rootCmd.AddCommand(
		queueCmd,
		dequeueCmd,
		signCmd,
		downloadCmd,
		uploadCmd,
		versionCmd,
	)
}
