package gon

const tmpl = `
source = ["{{.Source}}"]
bundle_id = "{{.BundleID}}"

apple_id {
  username = "{{.AcUsername}}"
  password = "@env:AC_PASSWORD"
}

zip {
  output_path = "{{.ZipPath}}"
}

sign {
  application_identity = "{{.ApplicationIdentity}}"
}
`

type tmplData struct {
	Source              string
	BundleID            string
	ZipPath             string
	AcUsername          string
	ApplicationIdentity string
	SeparateNotarize    bool
}
