package gon

import (
	"fmt"
	"html/template"
	"os"
	"os/exec"
	"strings"
)

type SignParams struct {
	Source              string
	BundleID            string
	AcUsername          string
	ApplicationIdentity string
}

func Sign(p *SignParams) error {
	cfgPath := "/tmp/gon.hcl"
	zipPath := "/tmp/to_notarize.zip"
	genConfig := func() error {
		f, err := os.Create(cfgPath)
		if err != nil {
			return fmt.Errorf("unable to create tmp file: %w", err)
		}
		defer func() { _ = f.Close() }()

		return template.Must(template.New("gon.hcl").Parse(tmpl)).Execute(f, tmplData{
			Source:              p.Source,
			BundleID:            p.BundleID,
			AcUsername:          p.AcUsername,
			ApplicationIdentity: p.ApplicationIdentity,
			ZipPath:             zipPath,
			SeparateNotarize:    strings.HasSuffix(p.Source, ".app"),
		})
	}

	err := genConfig()
	if err != nil {
		return fmt.Errorf("unable to gen gon config: %w", err)
	}

	cmd := exec.Command("gon", cfgPath)
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr
	return cmd.Run()
}
