package process

import (
	"os"
	"os/exec"
	"strings"
)

func Exec(cmd string, args ...string) (string, error) {
	c := exec.Command(cmd, args...)
	c.Stderr = os.Stderr
	var out strings.Builder
	c.Stdout = &out
	if err := c.Run(); err != nil {
		return "", err
	}

	return strings.TrimSpace(out.String()), nil
}
