package commands

import (
	"encoding/json"
	"io/ioutil"
	"log"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/meat/internal/config"
)

var (
	cfgFile string
	cfg     = &config.Config{
		Port:       3000,
		StaticRoot: "/tmp/meetings",
	}
)

var RootCmd = &cobra.Command{
	Use:          "meat",
	SilenceUsage: true,
	PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
		cfg.TVM.ClientSecret = os.Getenv("TVM_SECRET")
		cfg.SignSecret = os.Getenv("SIGN_SECRET")
		return nil
	},
}

func Execute() {
	if err := RootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	cobra.OnInitialize(initConfig)
	flags := RootCmd.PersistentFlags()
	flags.StringVar(&cfgFile, "config", "", "config file")
}

func initConfig() {
	if cfgFile == "" {
		cfgFile = "meat.json"
	}

	if !isPathExists(cfgFile) {
		return
	}

	cfgData, err := ioutil.ReadFile(cfgFile)
	if err != nil {
		log.Printf("failed to read config file: %v\n", err)
		return
	}

	cfgParsed := new(config.Config)
	err = json.Unmarshal(cfgData, cfgParsed)
	if err != nil {
		log.Printf("failed to parse config file: %v\n", err)
		return
	}

	cfg = cfgParsed
}

func isPathExists(path string) bool {
	_, err := os.Stat(path)
	return err == nil
}
